/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.toolkit;

import filenet.vw.api.VWException;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.idm.toolkit.IVWIDMAuthToken;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.toolkit.utils.IVWParameterConstants;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.applet.Applet;
import java.lang.reflect.Field;

public class VWIDMBaseFactory
implements IVWParameterConstants {
    private static IVWIDMFactory gInstance = null;
    private static String gWebApp = null;
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static final String m_className = "VWIDMBaseFactory";
    private static int m_refCount = 0;
    private static boolean gDebugging;
    private static IVWIDMAuthToken prevToken;

    public static boolean isDebugging() {
        return gDebugging;
    }

    private static void setDebugMode(boolean val) {
        gDebugging = val;
    }

    public static String getWebApp() {
        return gWebApp;
    }

    public static IVWIDMFactory instance() throws VWException {
        if (gInstance == null) {
            throw new VWException("idm.toolkit.VWIDMBaseFactory.instance", "Incomplete initialization!");
        }
        return gInstance;
    }

    public static IVWIDMFactory instance(String webApp) throws VWException {
        return VWIDMBaseFactory.instance(webApp, null);
    }

    private static String getVersion(String className) {
        if (className != null) {
            try {
                int nFields;
                Class<?> cls = Class.forName(className);
                Object obj = cls.newInstance();
                Field[] fields = cls.getFields();
                StringBuffer buf = new StringBuffer(512);
                buf.append(className).append("\n");
                int n = nFields = fields == null ? 0 : fields.length;
                while (--nFields > 0) {
                    String fieldName = fields[nFields].getName();
                    if (fieldName.equals("buildDateMask")) continue;
                    buf.append(fields[nFields].getName()).append("=").append(fields[nFields].get(obj)).append("\n");
                }
                return buf.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IVWIDMFactory instance(String webApp, Applet applet) throws VWException {
        VWTimerLog timer = new VWTimerLog("VWIDMBaseFactory.instance(APPLET) " + webApp);
        String m_method = "instance (Applet) " + webApp;
        try {
            logger.entering(m_className, m_method + ", refCount=" + Integer.toString(++m_refCount));
            String version = VWIDMBaseFactory.getVersion("filenet.vw.toolkit.utils.VWBuildStamp");
            System.out.println(version);
            String factoryClassName = null;
            String factoryPropertiesClassName = null;
            String sCanSaveToDMS = null;
            String singleInstance = null;
            gWebApp = webApp;
            if (applet != null) {
                block14: {
                    String inputFile = applet.getParameter("inputfile");
                    if (inputFile == null) break block14;
                    VWCommandLineArgs c = new VWCommandLineArgs(inputFile, false);
                    IVWIDMFactory res = VWIDMBaseFactory.instance(c);
                    VWIDMBaseFactory.setDebugMode(true);
                    IVWIDMFactory iVWIDMFactory = res;
                    Object var14_17 = null;
                    logger.exiting(m_className, m_method + ", refCount=" + Integer.toString(m_refCount));
                    return iVWIDMFactory;
                }
                try {
                    factoryClassName = applet.getParameter("factoryClassName");
                    factoryPropertiesClassName = applet.getParameter("factoryPropertiesClassName");
                    sCanSaveToDMS = applet.getParameter("canSaveToDMS");
                    singleInstance = applet.getParameter("singleInstance");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (webApp.equalsIgnoreCase("WEB_WORKFLO") || webApp.equalsIgnoreCase("OPEN_CLIENT")) {
                factoryClassName = "filenet.vw.idm.panagon.VWPanagonFactory";
                factoryPropertiesClassName = "filenet.vw.idm.panagon.VWPanagonFactoryProperties";
                sCanSaveToDMS = "true";
                if (webApp.equalsIgnoreCase("WEB_WORKFLO")) {
                    singleInstance = "true";
                }
            } else if (webApp.equalsIgnoreCase("WORKPLACE")) {
                factoryClassName = "filenet.vw.idm.trident.VWTridentFactory";
                factoryPropertiesClassName = "filenet.vw.idm.trident.VWTridentFactoryProperties";
                sCanSaveToDMS = "true";
            }
            if (factoryClassName == null) throw new VWException("idm.toolkit.VWIDMBaseFactory.instance.2", "Insufficient parameters.");
            if (factoryPropertiesClassName == null) throw new VWException("idm.toolkit.VWIDMBaseFactory.instance.2", "Insufficient parameters.");
            try {
                boolean newInstance = gInstance == null;
                IVWIDMFactoryProperties props = (IVWIDMFactoryProperties)Class.forName(factoryPropertiesClassName).newInstance();
                props.setProperty("webApp", webApp);
                props.setProperty("canSaveToDMS", new Boolean(sCanSaveToDMS != null));
                props.setProperty("singleInstance", new Boolean(singleInstance != null));
                props.getPropertiesFromApplet(applet);
                if (newInstance) {
                    gInstance = (IVWIDMFactory)Class.forName(factoryClassName).newInstance();
                }
                gInstance.setProperties(props);
                if (prevToken != null && !newInstance) {
                    gInstance.setVWSessionToken(prevToken.getUserName(), prevToken.getPassword(), prevToken.getGroup(), prevToken.getToken(), prevToken.getRouterURL());
                }
            }
            catch (Exception e) {
                throw new VWException("idm.toolkit.VWIDMBaseFactory.instance.InstantiateException", "{0}", e.getMessage());
            }
            IVWIDMFactory iVWIDMFactory = gInstance;
            Object var14_18 = null;
            logger.exiting(m_className, m_method + ", refCount=" + Integer.toString(m_refCount));
            return iVWIDMFactory;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            logger.exiting(m_className, m_method + ", refCount=" + Integer.toString(m_refCount));
            throw throwable;
        }
    }

    public static IVWIDMFactory instance(VWCommandLineArgs args) throws VWException {
        if (args == null) {
            throw new VWException("idm.toolkit.VWIDMBaseFactory.instance", "Incomplete initialization!");
        }
        try {
            String inputFile = args.getParameter("inputfile");
            if (inputFile != null) {
                VWCommandLineArgs c = new VWCommandLineArgs(inputFile, false);
                IVWIDMFactory res = VWIDMBaseFactory.instance(c);
                VWIDMBaseFactory.setDebugMode(true);
                return res;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        gWebApp = args.getParameter("webApp");
        if (gWebApp == null) {
            throw new VWException("idm.toolkit.VWIDMBaseFactory.instance", "No web application was specified.");
        }
        String m_method = "instance (CommandLineArs) " + gWebApp;
        logger.entering(m_className, m_method + ", refCount=" + Integer.toString(++m_refCount));
        String factoryClassName = args.getParameter("factoryClassName");
        String factoryPropertiesClassName = args.getParameter("factoryPropertiesClassName");
        String sCanSaveToDMS = args.getParameter("canSaveToDMS");
        String singleInstance = args.getParameter("singleInstance");
        if (gWebApp.equalsIgnoreCase("WEB_WORKFLO") || gWebApp.equalsIgnoreCase("OPEN_CLIENT")) {
            factoryClassName = "filenet.vw.idm.panagon.VWPanagonFactory";
            factoryPropertiesClassName = "filenet.vw.idm.panagon.VWPanagonFactoryProperties";
            sCanSaveToDMS = "true";
            if (gWebApp.equalsIgnoreCase("WEB_WORKFLO")) {
                singleInstance = "true";
            }
        } else if (gWebApp.equalsIgnoreCase("WORKPLACE")) {
            factoryClassName = "filenet.vw.idm.trident.VWTridentFactory";
            factoryPropertiesClassName = "filenet.vw.idm.trident.VWTridentFactoryProperties";
            sCanSaveToDMS = "true";
        }
        if (factoryClassName != null && factoryPropertiesClassName != null) {
            try {
                IVWIDMFactoryProperties props = (IVWIDMFactoryProperties)Class.forName(factoryPropertiesClassName).newInstance();
                props.setProperty("webApp", gWebApp);
                props.setProperty("canSaveToDMS", new Boolean(sCanSaveToDMS != null));
                props.setProperty("singleInstance", new Boolean(singleInstance != null));
                props.getPropertiesFromCommandLine(args);
                gInstance = (IVWIDMFactory)Class.forName(factoryClassName).newInstance();
                gInstance.setProperties(props);
            }
            catch (Exception e) {
                throw new VWException("idm.toolkit.VWIDMBaseFactory.instance.InstantiateException", "{0}", e.getMessage());
            }
        } else {
            throw new VWException("idm.toolkit.VWIDMBaseFactory.instance.2", "Insufficient parameters.");
        }
        return gInstance;
    }

    public static void release() {
        logger.entering(m_className, "release refCount=" + Integer.toString(--m_refCount));
        Boolean bResetRef = null;
        if (m_refCount == 0) {
            if (gInstance != null) {
                bResetRef = (Boolean)gInstance.getProperties().getProperty("singleInstance");
                if (bResetRef.booleanValue()) {
                    prevToken = gInstance.getVWSessionToken();
                }
                gInstance.release();
            }
            if (gWebApp != null && bResetRef != null && !bResetRef.booleanValue()) {
                gInstance = null;
                gWebApp = null;
            }
        }
        logger.exiting(m_className, "release refCount=" + Integer.toString(m_refCount));
    }

    static {
        try {
            XMLHelper.parseDocumentViaDOM(null, null, null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gDebugging = false;
        prevToken = null;
    }
}

